/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.api.events.IKeyEntryListenersEvent;
import com.blamejared.controlling.api.events.IKeyEntryMouseClickedEvent;
import com.blamejared.controlling.api.events.IKeyEntryMouseReleasedEvent;
import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.platform.Services;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.ArrayUtils;

public class NewKeyBindsList
extends CustomList {
    private final KeyBindsScreen controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;

    public NewKeyBindsList(KeyBindsScreen controls, Minecraft mcIn) {
        super(controls, mcIn);
        this.f_93388_ = controls.f_96543_ + 45;
        this.f_93389_ = controls.f_96544_;
        this.f_93390_ = 20;
        this.f_93391_ = controls.f_96544_ - 80;
        this.f_93392_ = controls.f_96543_ + 45;
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.m_6702_().clear();
        this.allEntries = new ArrayList();
        Object[] bindings = (KeyMapping[])ArrayUtils.clone((Object[])mcIn.f_91066_.f_92059_);
        Arrays.sort(bindings);
        String lastCategory = null;
        for (Object keybinding : bindings) {
            int width;
            String category = keybinding.m_90858_();
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                if (!category.endsWith(".hidden")) {
                    this.addEntry(new CategoryEntry(category));
                }
            }
            if ((width = mcIn.f_91062_.m_92895_(I18n.m_118938_((String)keybinding.m_90860_(), (Object[])new Object[0]))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = width;
            }
            if (category.endsWith(".hidden")) continue;
            this.addEntry(new KeyEntry((KeyMapping)keybinding));
        }
    }

    protected void m_7415_(PoseStack matrixStack, int mouseX, int mouseY) {
        KeyBindsList.Entry entry = this.getEntryAtPos(mouseY);
        if (entry instanceof KeyEntry) {
            KeyEntry keyEntry = (KeyEntry)entry;
            this.controlsScreen.m_96602_(matrixStack, (Component)new TranslatableComponent(keyEntry.getKeybinding().m_90858_()), mouseX, mouseY);
        }
    }

    public KeyBindsList.Entry getEntryAtPos(double mouseY) {
        if (mouseY <= (double)this.f_93390_ || mouseY >= (double)this.f_93391_) {
            return null;
        }
        int i1 = Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) - this.f_93395_ + (int)this.m_93517_() - 4;
        int itemIndex = i1 / this.f_93387_;
        return i1 >= 0 && itemIndex < this.m_5773_() ? (KeyBindsList.Entry)this.m_6702_().get(itemIndex) : null;
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    public class CategoryEntry
    extends KeyBindsList.Entry {
        private final String labelText;
        private final int labelWidth;
        private final String name;

        public CategoryEntry(String name) {
            this.labelText = I18n.m_118938_((String)name, (Object[])new Object[0]);
            this.labelWidth = NewKeyBindsList.this.mc.f_91062_.m_92895_(this.labelText);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void m_6311_(PoseStack stack, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            ((NewKeyBindsList)NewKeyBindsList.this).f_93386_.f_91062_.m_92883_(stack, this.labelText, (float)(Objects.requireNonNull(((NewKeyBindsList)NewKeyBindsList.this).f_93386_.f_91080_).f_96543_ / 2 - this.labelWidth / 2), (float)(y + rowWidth - 9 - 1), 0xFFFFFF);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput neo) {
                    neo.m_169143_(NarratedElementType.TITLE, CategoryEntry.this.labelText);
                }
            });
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }
    }

    public class KeyEntry
    extends KeyBindsList.Entry {
        private final KeyMapping keybinding;
        private final String keyDesc;
        private final Button btnChangeKeyBinding;
        private final Button btnResetKeyBinding;

        private KeyEntry(final KeyMapping name) {
            this.keybinding = name;
            this.keyDesc = I18n.m_118938_((String)name.m_90860_(), (Object[])new Object[0]);
            this.btnChangeKeyBinding = new Button(0, 0, 95, 20, (Component)new TextComponent(this.keyDesc), btn -> {
                NewKeyBindsList.this.controlsScreen.f_193975_ = name;
            }){

                protected MutableComponent m_5646_() {
                    return name.m_90862_() ? new TranslatableComponent("narrator.controls.unbound", new Object[]{KeyEntry.this.keyDesc}) : new TranslatableComponent("narrator.controls.bound", new Object[]{KeyEntry.this.keyDesc, super.m_5646_()});
                }
            };
            this.btnResetKeyBinding = new Button(0, 0, 50, 20, (Component)new TranslatableComponent("controls.reset"), btn -> {
                Services.PLATFORM.setToDefault(((NewKeyBindsList)NewKeyBindsList.this).f_93386_.f_91066_, name);
                KeyMapping.m_90854_();
            }){

                protected MutableComponent m_5646_() {
                    return new TranslatableComponent("narrator.controls.reset", new Object[]{KeyEntry.this.keyDesc});
                }
            };
        }

        public void m_6311_(PoseStack stack, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Services.EVENT.fireKeyEntryRenderEvent(this, stack, slotIndex, y, x, rowLeft, rowWidth, mouseX, mouseY, hovered, partialTicks);
            boolean flag = NewKeyBindsList.this.controlsScreen.f_193975_ == this.keybinding;
            int length = Math.max(0, x + 90 - NewKeyBindsList.this.maxListLabelWidth);
            NewKeyBindsList.this.mc.f_91062_.m_92883_(stack, this.keyDesc, (float)length, (float)(y + rowWidth / 2 - 4), 0xFFFFFF);
            this.btnResetKeyBinding.f_93620_ = x + 190 + 20;
            this.btnResetKeyBinding.f_93621_ = y;
            this.btnResetKeyBinding.f_93623_ = !this.keybinding.m_90864_();
            this.btnResetKeyBinding.m_6305_(stack, mouseX, mouseY, partialTicks);
            this.btnChangeKeyBinding.f_93620_ = x + 105;
            this.btnChangeKeyBinding.f_93621_ = y;
            this.btnChangeKeyBinding.m_93666_(this.keybinding.m_90863_());
            boolean flag1 = false;
            boolean keyCodeModifierConflict = true;
            if (!this.keybinding.m_90862_()) {
                for (KeyMapping otherBinding : NewKeyBindsList.this.mc.f_91066_.f_92059_) {
                    if (otherBinding == this.keybinding || !this.keybinding.m_90850_(otherBinding)) continue;
                    flag1 = true;
                    keyCodeModifierConflict &= Services.PLATFORM.hasConflictingModifier(this.keybinding, otherBinding);
                }
            }
            Component message = this.btnChangeKeyBinding.m_6035_();
            if (flag) {
                this.btnChangeKeyBinding.m_93666_((Component)new TextComponent(ChatFormatting.WHITE + "> " + ChatFormatting.YELLOW + message.getString() + ChatFormatting.WHITE + " <"));
            } else if (flag1) {
                this.btnChangeKeyBinding.m_93666_((Component)message.m_6881_().m_130940_(keyCodeModifierConflict ? ChatFormatting.GOLD : ChatFormatting.RED));
            }
            this.btnChangeKeyBinding.m_6305_(stack, mouseX, mouseY, partialTicks);
        }

        public List<GuiEventListener> m_6702_() {
            return (List)Services.EVENT.fireKeyEntryListenersEvent(this).map(IKeyEntryListenersEvent::getListeners, UnaryOperator.identity());
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.btnChangeKeyBinding, (Object)this.btnResetKeyBinding);
        }

        public boolean m_6375_(double mouseX, double mouseY, int buttonId) {
            if (((Boolean)Services.EVENT.fireKeyEntryMouseClickedEvent(this, mouseX, mouseY, buttonId).map(IKeyEntryMouseClickedEvent::isHandled, UnaryOperator.identity())).booleanValue()) {
                return true;
            }
            if (this.btnChangeKeyBinding.m_6375_(mouseX, mouseY, buttonId)) {
                return true;
            }
            return this.btnResetKeyBinding.m_6375_(mouseX, mouseY, buttonId);
        }

        public boolean m_6348_(double mouseX, double mouseY, int buttonId) {
            if (((Boolean)Services.EVENT.fireKeyEntryMouseReleasedEvent(this, mouseX, mouseY, buttonId).map(IKeyEntryMouseReleasedEvent::isHandled, UnaryOperator.identity())).booleanValue()) {
                return true;
            }
            return this.btnChangeKeyBinding.m_6348_(mouseX, mouseY, buttonId);
        }

        public KeyMapping getKeybinding() {
            return this.keybinding;
        }

        public String getKeyDesc() {
            return this.keyDesc;
        }

        public Button getBtnResetKeyBinding() {
            return this.btnResetKeyBinding;
        }

        public Button getBtnChangeKeyBinding() {
            return this.btnChangeKeyBinding;
        }
    }
}

